import os
from os.path import isfile, join
import pygame
import time
import signal
import keyboard

dir_path = os.getcwd()
sound_dir = os.getcwd() + "/sounds"
contentlist = os.listdir(sound_dir)
sound_array = []
cut_current_sound = False
channel = False
current_sound_index = -1


def setup_sounds():
    for content in contentlist:
        if isfile(join(sound_dir, content)):
            if content.endswith(".mp3") or content.endswith(".wav"):
                sound = pygame.mixer.Sound(join(sound_dir, content))
                sound_array.append(sound)
    print(sound_array)


def play_sound(index):
    global cut_current_sound
    global current_sound_index
    global channel    

    if not cut_current_sound:
        current_sound_index = index
        channel = sound_array[current_sound_index].play()
        while channel.get_busy():
            pygame.time.wait(100)  # ms
            print("Playing...")
        print("Finished.")
        
  
    """ todo
    make sounds stop when new key pressed
    
     
    else:
        if current_sound_index == index:
            current_sound_index = index
            channel = sound_array[current_sound_index].play()
            while channel.get_busy():
                pygame.time.wait(100)  # ms
                print("Playing...")
            print("Finished.")
        else:
            print("STOP.")
            
    """

pygame.init()
setup_sounds()



while True: 
    try:  # used try so that if user pressed other than the given key error will not be shown
        if keyboard.is_pressed("q"):
            print("You Pressed A Key!")
            play_sound(0)
        elif keyboard.is_pressed("w"):
            print("You Pressed A Key!")
            play_sound(1)
        elif keyboard.is_pressed("e"):
            print("You Pressed A Key!")
            play_sound(2)
        elif keyboard.is_pressed("r"): 
            print("You Pressed A Key!")
            play_sound(3)
    except:
        break  # if user pressed a key other than the given key the loop will break


# time.sleep(5.5)
# signal.pause()
