#!/bin/bash

# Warte bis ein USB-Gerät auftaucht
TIMEOUT=30
SECONDS_WAITED=0

echo "Waiting for X..."
while ! pgrep -x Xorg > /dev/null; do
  sleep 1
done

echo "Waiting for USB (max $TIMEOUT sec)..."
while [ $SECONDS_WAITED -lt $TIMEOUT ]; do
    if lsblk | grep -q 'sd[b-z]'; then
        echo "USB device detected."
        break
    fi
    sleep 1
    SECONDS_WAITED=$((SECONDS_WAITED + 1))
done

exit 0